package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class EditProfileViewModel(
    private val context: Context,
    private val userRepository: UserRepository

) : ViewModel(){

    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences=Functions.getSharedPreference(context)
    }



    val _userDetailLiveData: MutableLiveData<ApiResponce<UserModel>> = MutableLiveData()
    val userDetailLiveData: LiveData<ApiResponce<UserModel>> get() = _userDetailLiveData

    fun getUserDetails(){
        viewModelScope.launch {

            val param = JSONObject()
            if(sharedPreferences.getBoolean(Variables.IS_LOGIN,false)) {
                param.put("auth_token", Functions.getSharedPreference(context).getString(Variables.AUTH_TOKEN, ""))
            }
            userRepository.showUserDetail(param, _userDetailLiveData)
        }
    }




    val _editProfileLiveData: MutableLiveData<ApiResponce<UserModel>> = MutableLiveData()
    val editProfileLiveData: LiveData<ApiResponce<UserModel>> get() = _editProfileLiveData

    fun editProfile(params:JSONObject){
        viewModelScope.launch {
            userRepository.callApiEditProfile(params, _editProfileLiveData)
        }
    }



}
